"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsPage = exports.ALERTS_PAGE_LOADING_TEST_ID = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _wrapper = require("../../components/alerts/wrapper");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _no_api_integration_key_callout = require("../../components/callouts/no_api_integration_key_callout");
var _user_info = require("../../components/user_info");
var _no_index_empty_page = require("../../components/alerts/empty_pages/no_index_empty_page");
var _use_lists_config = require("../../containers/detection_engine/lists/use_lists_config");
var _user_unauthenticated_empty_page = require("../../components/alerts/empty_pages/user_unauthenticated_empty_page");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_signal_helpers = require("../../../sourcerer/containers/use_signal_helpers");
var _need_admin_for_update_rules_callout = require("../../../detection_engine/rule_management/components/callouts/need_admin_for_update_rules_callout");
var _missing_detections_privileges_callout = require("../../components/callouts/missing_detections_privileges_callout");
var _no_privileges = require("../../../common/components/no_privileges");
var _header_page = require("../../../common/components/header_page");
var _user_privileges = require("../../../common/components/user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/pages/alerts/alerts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALERTS_PAGE_LOADING_TEST_ID = exports.ALERTS_PAGE_LOADING_TEST_ID = 'alerts-page-loading';

/**
 * Renders the potential callouts, handles missing privileges and the basic loading before
 * the actual content of the alerts page is rendered
 */
const AlertsPage = exports.AlertsPage = /*#__PURE__*/(0, _react.memo)(() => {
  const [{
    loading: userInfoLoading,
    isAuthenticated,
    hasIndexRead
  }] = (0, _user_info.useUserData)();
  const canReadAlerts = (0, _user_privileges.useUserPrivileges)().rulesPrivileges.read;
  const {
    loading: listsConfigLoading,
    needsConfiguration: needsListsConfiguration
  } = (0, _use_lists_config.useListsConfig)();
  const {
    signalIndexNeedsInit
  } = (0, _use_signal_helpers.useSignalHelpers)();
  const loading = (0, _react.useMemo)(() => userInfoLoading || listsConfigLoading, [listsConfigLoading, userInfoLoading]);
  const userNotAuthenticated = (0, _react.useMemo)(() => isAuthenticated != null && !isAuthenticated, [isAuthenticated]);
  const noIndex = (0, _react.useMemo)(() => signalIndexNeedsInit || needsListsConfiguration, [needsListsConfiguration, signalIndexNeedsInit]);
  const privilegesRequired = (0, _react.useMemo)(() => !signalIndexNeedsInit && (hasIndexRead === false || canReadAlerts === false), [canReadAlerts, hasIndexRead, signalIndexNeedsInit]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
      border: true,
      title: i18n.PAGE_TITLE,
      isLoading: loading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": ALERTS_PAGE_LOADING_TEST_ID,
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    })));
  }
  if (userNotAuthenticated) {
    return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
      border: true,
      title: i18n.PAGE_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_user_unauthenticated_empty_page.UserUnauthenticatedEmptyPage, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }));
  }
  if (noIndex) {
    return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
      border: true,
      title: i18n.PAGE_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_no_index_empty_page.NoIndexEmptyPage, {
      needsListsIndex: needsListsConfiguration,
      needsSignalsIndex: signalIndexNeedsInit,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_no_api_integration_key_callout.NoApiIntegrationKeyCallOut, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_need_admin_for_update_rules_callout.NeedAdminForUpdateRulesCallOut, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_missing_detections_privileges_callout.MissingDetectionsPrivilegesCallOut, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), privilegesRequired ? /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivileges, {
    pageName: i18n.PAGE_TITLE.toLowerCase(),
    docLinkSelector: docLinks => docLinks.siem.privileges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_wrapper.Wrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }));
});
AlertsPage.displayName = 'AlertsPage';