"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetDefaultGroupTitleRenderers = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _field_names = require("../../../../common/field_maps/field_names");
var _use_find_attack_discoveries = require("../../../attack_discovery/pages/use_find_attack_discoveries");
var _attack_group_content = require("../../components/attacks/table/attack_group_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/hooks/attacks/use_get_default_group_title_renderers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EMPTY_ARRAY = [];

/**
 * Props for the useGetDefaultGroupTitleRenderers hook
 */

/**
 * Pre-caches attack discovery documents using the provided attack IDs and returns
 * a renderer function that uses these cached documents for individual group component rendering.
 * This hook optimizes performance by fetching all required attack data upfront rather than
 * on-demand during rendering.
 *
 * @param props - The hook props
 * @param props.attackIds - Optional array of attack IDs to pre-fetch and cache
 * @param props.showAnonymized - When true, displays anonymized values; when false, displays original values
 * @returns An object containing the defaultGroupTitleRenderers function for rendering group titles
 */
const useGetDefaultGroupTitleRenderers = ({
  attackIds,
  showAnonymized
}) => {
  var _attackIds$length;
  const {
    assistantAvailability,
    http
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    data: attacksData,
    isLoading: isLoadingAttacks
  } = (0, _use_find_attack_discoveries.useFindAttackDiscoveries)({
    ids: attackIds,
    http,
    isAssistantEnabled: assistantAvailability.isAssistantEnabled,
    perPage: Math.max((_attackIds$length = attackIds === null || attackIds === void 0 ? void 0 : attackIds.length) !== null && _attackIds$length !== void 0 ? _attackIds$length : 1, 1)
  });
  const attacks = (0, _react.useMemo)(() => {
    if (isLoadingAttacks || !(attacksData !== null && attacksData !== void 0 && attacksData.data.length)) {
      return EMPTY_ARRAY;
    }
    return attacksData.data;
  }, [attacksData === null || attacksData === void 0 ? void 0 : attacksData.data, isLoadingAttacks]);
  const defaultGroupTitleRenderers = (0, _react.useCallback)((selectedGroup, bucket) => {
    switch (selectedGroup) {
      case _field_names.ALERT_ATTACK_IDS:
        {
          if ((0, _fp.isArray)(bucket.key) && bucket.key.length !== 1) {
            return undefined;
          }
          const attackId = (0, _fp.isArray)(bucket.key) ? bucket.key[0] : bucket.key;
          const attack = attacks.find(({
            id
          }) => id === attackId);
          if (!attack) {
            return undefined;
          }
          return /*#__PURE__*/_react.default.createElement(_attack_group_content.AttackGroupContent, {
            attack: attack,
            dataTestSubj: "attack",
            showAnonymized: showAnonymized,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 75,
              columnNumber: 13
            }
          });
        }
    }
  }, [attacks, showAnonymized]);
  return {
    defaultGroupTitleRenderers
  };
};
exports.useGetDefaultGroupTitleRenderers = useGetDefaultGroupTitleRenderers;