"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CellValue = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _kibana = require("../../../common/lib/kibana");
var _renderers = require("../../../timelines/components/timeline/body/renderers");
var _constants = require("../../../timelines/components/timeline/body/renderers/constants");
var _default_cell_renderer = require("../../../timelines/components/timeline/cell_rendering/default_cell_renderer");
var _translations = require("./translations");
var _cell_value_context = require("./cell_value_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/configurations/security_solution_detections/render_cell_value.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * This implementation of `EuiDataGrid`'s `renderCellValue`
 * accepts `EuiDataGridCellValueElementProps`, plus `data`
 * from the TGrid
 */

const CellValue = exports.CellValue = /*#__PURE__*/(0, _react.memo)(function RenderCellValue({
  columnId,
  rowIndex,
  pageScope,
  tableId,
  tableType,
  header,
  legacyAlert,
  ecsAlert,
  linkValues,
  rowRenderers,
  isDetails,
  isExpandable,
  isExpanded,
  colIndex,
  eventId,
  setCellProps,
  truncate,
  userProfiles
}) {
  const {
    notifications
  } = (0, _kibana.useKibana)().services;
  const cellValueContext = (0, _react.useContext)(_cell_value_context.AlertTableCellContext);
  if (!cellValueContext) {
    const contextMissingError = new Error('render_cell_value.tsx: CellValue must be used within AlertTableCellContextProvider');
    notifications.toasts.addError(contextMissingError, {
      title: 'AlertTableCellContextProvider is missing',
      toastMessage: 'CellValue must be used within AlertTableCellContextProvider'
    });
    throw new Error(contextMissingError.message);
  }
  const {
    browserFields,
    browserFieldsByName,
    columnHeaders
  } = cellValueContext;
  /**
   * There is difference between how `triggers actions` fetched data v/s
   * how security solution fetches data via timelineSearchStrategy
   *
   * _id and _index fields are array in timelineSearchStrategy  but not in
   * ruleStrategy
   *
   *
   */

  const finalData = (0, _react.useMemo)(() => {
    return legacyAlert.map(field => {
      if (['_id', '_index'].includes(field.field)) {
        var _field$value;
        const newValue = (_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : '';
        return {
          field: field.field,
          value: Array.isArray(newValue) ? newValue : [newValue]
        };
      } else {
        return field;
      }
    });
  }, [legacyAlert]);
  const actualSuppressionCount = (0, _react.useMemo)(() => {
    var _ecsAlert$kibana, _ecsAlert$kibana$aler, _ecsAlert$kibana$aler2, _find, _find$value;
    // We check both ecsAlert and data for the suppression count because it could be in either one,
    // depending on where RenderCellValue is being used - when used in cases, data is populated,
    // whereas in the regular security alerts table it's in ecsAlert
    const ecsSuppressionCount = ecsAlert === null || ecsAlert === void 0 ? void 0 : (_ecsAlert$kibana = ecsAlert.kibana) === null || _ecsAlert$kibana === void 0 ? void 0 : (_ecsAlert$kibana$aler = _ecsAlert$kibana.alert.suppression) === null || _ecsAlert$kibana$aler === void 0 ? void 0 : (_ecsAlert$kibana$aler2 = _ecsAlert$kibana$aler.docs_count) === null || _ecsAlert$kibana$aler2 === void 0 ? void 0 : _ecsAlert$kibana$aler2[0];
    const dataSuppressionCount = (_find = (0, _fp.find)({
      field: 'kibana.alert.suppression.docs_count'
    }, legacyAlert)) === null || _find === void 0 ? void 0 : (_find$value = _find.value) === null || _find$value === void 0 ? void 0 : _find$value[0];
    return ecsSuppressionCount ? parseInt(ecsSuppressionCount, 10) : dataSuppressionCount;
  }, [ecsAlert, legacyAlert]);
  const myHeader = (0, _react.useMemo)(() => header !== null && header !== void 0 ? header : {
    id: columnId,
    ...browserFieldsByName[columnId]
  }, [browserFieldsByName, columnId, header]);
  const colHeader = (0, _react.useMemo)(() => columnHeaders.find(col => col.id === columnId), [columnHeaders, columnId]);
  const localLinkValues = (0, _react.useMemo)(() => {
    var _colHeader$linkField;
    return (0, _fp.getOr)([], (_colHeader$linkField = colHeader === null || colHeader === void 0 ? void 0 : colHeader.linkField) !== null && _colHeader$linkField !== void 0 ? _colHeader$linkField : '', ecsAlert);
  }, [colHeader === null || colHeader === void 0 ? void 0 : colHeader.linkField, ecsAlert]);
  const CellRenderer = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_default_cell_renderer.DefaultCellRenderer, {
      browserFields: browserFields,
      columnId: columnId,
      data: finalData,
      ecsData: ecsAlert,
      eventId: eventId,
      header: myHeader,
      isDetails: isDetails,
      isExpandable: isExpandable,
      isExpanded: isExpanded,
      linkValues: linkValues !== null && linkValues !== void 0 ? linkValues : localLinkValues,
      rowIndex: rowIndex,
      colIndex: colIndex,
      rowRenderers: rowRenderers !== null && rowRenderers !== void 0 ? rowRenderers : _renderers.defaultRowRenderers,
      setCellProps: setCellProps,
      scopeId: pageScope,
      truncate: truncate,
      asPlainText: false,
      context: userProfiles,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 7
      }
    });
  }, [browserFields, columnId, finalData, ecsAlert, eventId, myHeader, isDetails, isExpandable, isExpanded, linkValues, localLinkValues, rowIndex, colIndex, rowRenderers, setCellProps, pageScope, truncate, userProfiles]);
  return columnId === _constants.SIGNAL_RULE_NAME_FIELD_NAME && actualSuppressionCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: (0, _translations.SUPPRESSED_ALERT_TOOLTIP)(actualSuppressionCount),
    position: "top",
    type: "layers",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }, CellRenderer)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, CellRenderer);
});