"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingAttacksPrivilegesCallOut = void 0;
var _react = _interopRequireWildcard(require("react"));
var _missing_privileges = require("../../../common/components/missing_privileges");
var _use_missing_privileges = require("../../../common/hooks/use_missing_privileges");
var _use_get_missing_index_privileges = require("../../../attack_discovery/pages/use_get_missing_index_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/callouts/missing_attacks_privileges_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MissingAttacksPrivilegesCallOut = exports.MissingAttacksPrivilegesCallOut = /*#__PURE__*/_react.default.memo(() => {
  const missingDetectionsPrivileges = (0, _use_missing_privileges.useMissingPrivileges)();
  const {
    data: missingIndexPrivileges = []
  } = (0, _use_get_missing_index_privileges.useGetMissingIndexPrivileges)();
  const missingPrivileges = (0, _react.useMemo)(() => {
    return {
      featurePrivileges: missingDetectionsPrivileges.featurePrivileges,
      indexPrivileges: [...missingDetectionsPrivileges.indexPrivileges,
      // include missing attack discovery index privileges
      ...missingIndexPrivileges.map(({
        index_name: indexName,
        privileges
      }) => [indexName, privileges])]
    };
  }, [missingDetectionsPrivileges, missingIndexPrivileges]);
  return /*#__PURE__*/_react.default.createElement(_missing_privileges.MissingPrivilegesCallOut, {
    namespace: "attacks",
    missingPrivileges: missingPrivileges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 10
    }
  });
});
MissingAttacksPrivilegesCallOut.displayName = 'MissingAttacksPrivilegesCallOut';