"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupingSettings = exports.groupingOptions = void 0;
var _i18n = require("@kbn/i18n");
var _field_names = require("../../../../../common/field_maps/field_names");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ATTACK_NAME = _i18n.i18n.translate('xpack.securitySolution.attacks.alertsTable.groups.attackName', {
  defaultMessage: 'Attack'
});
const GROUP_BY_ATTACK_LABEL = _i18n.i18n.translate('xpack.securitySolution.attacks.alertsTable.groups.popoverButtonLabel', {
  defaultMessage: 'Group by attack'
});

/**
 * Returns a list of fields for the default grouping options. These are displayed in the `Group alerts by` dropdown button.
 * The default values are:
 * - kibana.alert.attack_ids
 *
 * These go hand in hand with groupTitleRenderers, groupStatsRenderer and groupStatsAggregations
 */
const groupingOptions = exports.groupingOptions = [{
  label: ATTACK_NAME,
  key: _field_names.ALERT_ATTACK_IDS
}];
const groupingSettings = exports.groupingSettings = {
  hideNoneOption: true,
  hideCustomFieldOption: true,
  hideOptionsTitle: true,
  popoverButtonLabel: GROUP_BY_ATTACK_LABEL,
  enforcedGroups: [_field_names.ALERT_ATTACK_IDS]
};