"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackGroupContent = exports.ATTACK_TITLE_TEST_ID_SUFFIX = exports.ATTACK_GROUP_TEST_ID_SUFFIX = exports.ATTACK_DESCRIPTION_TEST_ID_SUFFIX = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _attack_discovery_markdown_formatter = require("../../../../../attack_discovery/pages/results/attack_discovery_markdown_formatter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/attacks/table/attack_group_content/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ATTACK_GROUP_TEST_ID_SUFFIX = exports.ATTACK_GROUP_TEST_ID_SUFFIX = '-group-renderer';
const ATTACK_TITLE_TEST_ID_SUFFIX = exports.ATTACK_TITLE_TEST_ID_SUFFIX = '-title';
const ATTACK_DESCRIPTION_TEST_ID_SUFFIX = exports.ATTACK_DESCRIPTION_TEST_ID_SUFFIX = '-description';
const AttackGroupContent = exports.AttackGroupContent = /*#__PURE__*/_react.default.memo(({
  attack,
  dataTestSubj,
  showAnonymized = false
}) => {
  const title = (0, _react.useMemo)(() => showAnonymized ? attack.title : (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
    messageContent: attack.title,
    replacements: attack.replacements
  }), [attack.replacements, attack.title, showAnonymized]);
  const summary = (0, _react.useMemo)(() => showAnonymized ? attack.summaryMarkdown : (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
    messageContent: attack.summaryMarkdown,
    replacements: attack.replacements
  }), [attack.summaryMarkdown, attack.replacements, showAnonymized]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": `${dataTestSubj}${ATTACK_GROUP_TEST_ID_SUFFIX}`,
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": `${dataTestSubj}${ATTACK_TITLE_TEST_ID_SUFFIX}`,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": `${dataTestSubj}${ATTACK_DESCRIPTION_TEST_ID_SUFFIX}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_attack_discovery_markdown_formatter.AttackDiscoveryMarkdownFormatter, {
    disableActions: true,
    markdown: summary,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  })));
});
AttackGroupContent.displayName = 'AttackGroupContent';