"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionAddButton = exports.PLATINUM_ONLY_TOOLTIP = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_license = require("../../common/hooks/use_license");
var _shared_imports = require("../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_response_actions/response_action_add_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PLATINUM_ONLY_TOOLTIP = exports.PLATINUM_ONLY_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.actionForm.platinumOnly', {
  defaultMessage: 'This functionality is available only in Platinum and above.'
});
const ResponseActionAddButton = ({
  supportedResponseActionTypes,
  addActionType,
  updateActionTypeId
}) => {
  const [data] = (0, _shared_imports.useFormData)();
  const [isAddResponseActionButtonShown, setAddResponseActionButtonShown] = (0, _react.useState)(data.responseActions && data.responseActions.length > 0);
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const handleAddActionType = (0, _react.useCallback)(item => {
    setAddResponseActionButtonShown(false);
    addActionType();
    updateActionTypeId(item.id);
  }, [addActionType, updateActionTypeId]);
  const renderAddResponseActionButton = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: 'row',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      "data-test-subj": "addAlertActionButton",
      onClick: () => setAddResponseActionButtonShown(false),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.sections.actionForm.addResponseActionButtonLabel",
      defaultMessage: "Add response action",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 13
      }
    }))));
  }, []);
  const renderResponseActionTypes = (0, _react.useMemo)(() => {
    return (supportedResponseActionTypes === null || supportedResponseActionTypes === void 0 ? void 0 : supportedResponseActionTypes.length) && supportedResponseActionTypes.map(function (item, index) {
      const keyPadItem = /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenuItem, {
        key: index,
        isDisabled: !isPlatinumPlus || item.disabled,
        "data-test-subj": `${item.name}-response-action-type-selection-option`,
        label: item.name,
        betaBadgeTooltipContent: 'should be visible',
        onClick: () => handleAddActionType(item),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "xl",
        type: item.iconClass,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 13
        }
      }));
      if (!isPlatinumPlus) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          position: "top",
          content: PLATINUM_ONLY_TOOLTIP,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 97,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          key: `keypad-${item.id}`,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 15
          }
        }, keyPadItem));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: `keypad-${item.id}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 11
        }
      }, keyPadItem);
    });
  }, [handleAddActionType, isPlatinumPlus, supportedResponseActionTypes]);
  if (!(supportedResponseActionTypes !== null && supportedResponseActionTypes !== void 0 && supportedResponseActionTypes.length)) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isAddResponseActionButtonShown ? renderAddResponseActionButton : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'row',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, renderResponseActionTypes));
};
exports.ResponseActionAddButton = ResponseActionAddButton;