"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHORT_EMPTY_TITLE = exports.PERMISSION_DENIED = exports.NOT_AVAILABLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHORT_EMPTY_TITLE = exports.SHORT_EMPTY_TITLE = _i18n.i18n.translate('xpack.securitySolution.osquery.action.shortEmptyTitle', {
  defaultMessage: 'Osquery is not available'
});
const PERMISSION_DENIED = exports.PERMISSION_DENIED = _i18n.i18n.translate('xpack.securitySolution.osquery.action.permissionDenied', {
  defaultMessage: 'Permission denied'
});
const NOT_AVAILABLE = exports.NOT_AVAILABLE = _i18n.i18n.translate('xpack.securitySolution.osquery.action.unavailable', {
  defaultMessage: 'The Osquery Manager integration is not added to the agent policy. To run queries on the host, add the Osquery Manager integration to the agent policy in Fleet.'
});