"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSetupDetectionEngineHealthApi = exports.SETUP_DETECTION_ENGINE_HEALTH_API_MUTATION_KEY = void 0;
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _rule_monitoring = require("../../../../../common/api/detection_engine/rule_monitoring");
var _api = require("../../api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SETUP_DETECTION_ENGINE_HEALTH_API_MUTATION_KEY = exports.SETUP_DETECTION_ENGINE_HEALTH_API_MUTATION_KEY = ['POST', _rule_monitoring.SETUP_HEALTH_URL];
const useSetupDetectionEngineHealthApi = options => {
  const {
    mutate: setupDetectionEngineHealthApi
  } = (0, _reactQuery.useMutation)(() => _api.api.setupDetectionEngineHealthApi(), {
    ...options,
    mutationKey: SETUP_DETECTION_ENGINE_HEALTH_API_MUTATION_KEY
  });
  (0, _react.useEffect)(() => {
    setupDetectionEngineHealthApi();
  }, [setupDetectionEngineHealthApi]);
};
exports.useSetupDetectionEngineHealthApi = useSetupDetectionEngineHealthApi;