"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoverageOverviewMitreTechniquePanelPopover = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireWildcard(require("react"));
var _popover_list_header = require("./shared_components/popover_list_header");
var _technique_panel = require("./technique_panel");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_columns = require("../../components/rules_table/use_columns");
var _coverage_overview_dashboard_context = require("./coverage_overview_dashboard_context");
var _mitre_subtechnique = require("../../../rule_management/model/coverage_overview/mitre_subtechnique");
var _user_privileges = require("../../../../common/components/user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/pages/coverage_overview/technique_panel_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CoverageOverviewMitreTechniquePanelPopoverComponent = ({
  technique
}) => {
  const canEditRules = (0, _user_privileges.useUserPrivileges)().rulesPrivileges.edit;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const isEnableButtonDisabled = (0, _react.useMemo)(() => !canEditRules || technique.disabledRules.length === 0, [canEditRules, technique.disabledRules.length]);
  const isEnableButtonLoading = isLoading;
  const {
    state: {
      showExpandedCells,
      filter: {
        activity
      }
    },
    actions: {
      enableAllDisabled
    }
  } = (0, _coverage_overview_dashboard_context.useCoverageOverviewDashboardContext)();
  const coveredSubtechniques = (0, _react.useMemo)(() => (0, _mitre_subtechnique.getNumOfCoveredSubtechniques)(technique, activity), [activity, technique]);
  const handleEnableAllDisabled = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    const ruleIds = technique.disabledRules.map(rule => rule.id);
    await enableAllDisabled(ruleIds);
    setIsLoading(false);
    closePopover();
  }, [closePopover, enableAllDisabled, technique.disabledRules]);
  const TechniquePanel = /*#__PURE__*/_react.default.createElement(_technique_panel.CoverageOverviewMitreTechniquePanel, {
    setIsPopoverOpen: setIsPopoverOpen,
    isPopoverOpen: isPopoverOpen,
    technique: technique,
    isExpanded: showExpandedCells,
    coveredSubtechniques: coveredSubtechniques,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  });
  const CoveredSubtechniquesLabel = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "success",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, i18n.COVERED_MITRE_SUBTECHNIQUES(coveredSubtechniques, technique.subtechniques.length))), [coveredSubtechniques, technique.subtechniques.length]);
  const enabledRuleListItems = (0, _react.useMemo)(() => technique.enabledRules.map(rule => ({
    label: /*#__PURE__*/_react.default.createElement(_use_columns.RuleLink, {
      name: rule.name,
      id: rule.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 16
      }
    }),
    color: 'primary'
  })), [technique.enabledRules]);
  const disabledRuleListItems = (0, _react.useMemo)(() => technique.disabledRules.map(rule => ({
    label: /*#__PURE__*/_react.default.createElement(_use_columns.RuleLink, {
      name: rule.name,
      id: rule.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 16
      }
    }),
    color: 'primary'
  })), [technique.disabledRules]);
  const EnabledRulesAccordionButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_popover_list_header.CoverageOverviewRuleListHeader, {
    listTitle: i18n.ENABLED_RULES_LIST_LABEL,
    listLength: technique.enabledRules.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }), [technique.enabledRules.length]);
  const DisabledRulesAccordionButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_popover_list_header.CoverageOverviewRuleListHeader, {
    listTitle: i18n.DISABLED_RULES_LIST_LABEL,
    listLength: technique.disabledRules.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }), [technique.disabledRules.length]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: TechniquePanel,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "rightCenter",
    "data-test-subj": "coverageOverviewPopover",
    ownFocus: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    className: (0, _css.css)`
          min-width: 30em;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "flexStart",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    iconType: "popout",
    iconSide: "right",
    href: technique.reference,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 17
    }
  }, technique.name)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, CoveredSubtechniquesLabel))), /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _css.cx)((0, _css.css)({
      maxHeight: '40em',
      padding: '5px 0px'
    }), 'eui-yScrollWithShadows'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "enabledRulesListAccordion",
    initialIsOpen: technique.enabledRules.length > 0,
    buttonContent: EnabledRulesAccordionButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    "data-test-subj": "coverageOverviewEnabledRulesList",
    flush: true,
    listItems: enabledRuleListItems,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "disabledRulesListAccordion",
    initialIsOpen: technique.disabledRules.length > 0,
    buttonContent: DisabledRulesAccordionButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    "data-test-subj": "coverageOverviewDisabledRulesList",
    flush: true,
    listItems: disabledRuleListItems,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enableAllDisabledButton",
    isLoading: isEnableButtonLoading,
    disabled: isEnableButtonDisabled,
    onClick: handleEnableAllDisabled,
    size: "s",
    iconType: "checkInCircleFilled",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 13
    }
  }, i18n.ENABLE_ALL_DISABLED)))));
};
const CoverageOverviewMitreTechniquePanelPopover = exports.CoverageOverviewMitreTechniquePanelPopover = /*#__PURE__*/(0, _react.memo)(CoverageOverviewMitreTechniquePanelPopoverComponent);