"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleCustomizationFilterPopover = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _detection_engine = require("../../../../../../common/api/detection_engine");
var i18n = _interopRequireWildcard(require("../../../../common/translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/upgrade_rule_customization_filter_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RULE_CUSTOMIZATION_POPOVER_WIDTH = 200;
const RuleCustomizationFilterPopoverComponent = ({
  customizationStatus,
  onCustomizationStatusChanged
}) => {
  const [isRuleCustomizationPopoverOpen, setIsRuleCustomizationPopoverOpen] = (0, _react.useState)(false);
  const selectableOptions = (0, _react.useMemo)(() => [{
    label: i18n.MODIFIED_LABEL,
    key: _detection_engine.RuleCustomizationStatus.CUSTOMIZED,
    checked: customizationStatus === _detection_engine.RuleCustomizationStatus.CUSTOMIZED ? 'on' : undefined
  }, {
    label: i18n.UNMODIFIED_LABEL,
    key: _detection_engine.RuleCustomizationStatus.NOT_CUSTOMIZED,
    checked: customizationStatus === _detection_engine.RuleCustomizationStatus.NOT_CUSTOMIZED ? 'on' : undefined
  }], [customizationStatus]);
  const handleSelectableOptionsChange = (newOptions, _, changedOption) => {
    onCustomizationStatusChanged(changedOption.checked === 'on' ? changedOption.key : undefined);
  };
  const triggerButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    grow: true,
    iconType: "arrowDown",
    onClick: () => setIsRuleCustomizationPopoverOpen(!isRuleCustomizationPopoverOpen),
    numFilters: selectableOptions.length,
    isSelected: isRuleCustomizationPopoverOpen,
    hasActiveFilters: customizationStatus != null,
    numActiveFilters: customizationStatus != null ? 1 : 0,
    "data-test-subj": "rule-customization-filter-popover-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, i18n.RULE_SOURCE);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: triggerButton,
    isOpen: isRuleCustomizationPopoverOpen,
    closePopover: () => setIsRuleCustomizationPopoverOpen(!isRuleCustomizationPopoverOpen),
    panelPaddingSize: "none",
    repositionOnScroll: true,
    panelProps: {
      'data-test-subj': 'rule-customization-filter-popover'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: selectableOptions,
    onChange: handleSelectableOptionsChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: RULE_CUSTOMIZATION_POPOVER_WIDTH
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 20
    }
  }, list)));
};
const RuleCustomizationFilterPopover = exports.RuleCustomizationFilterPopover = /*#__PURE__*/_react.default.memo(RuleCustomizationFilterPopoverComponent);