"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.gapStatusTooltipUnfilled = exports.gapStatusTooltipInProgress = exports.gapStatusTooltipFilled = exports.SELECTED_RULES = exports.RULE_UPDATES_TAB = exports.RULE_MONITORING_TAB = exports.ML_RULE_JOBS_WARNING_DESCRIPTION = exports.ML_RULE_JOBS_WARNING_BUTTON_LABEL = exports.INSTALLED_RULES_TAB = exports.GAP_STATUS_UNFILLED_LABEL = exports.GAP_STATUS_IN_PROGRESS_LABEL = exports.GAP_STATUS_HEADER = exports.GAP_STATUS_FILLED_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ML_RULE_JOBS_WARNING_DESCRIPTION = exports.ML_RULE_JOBS_WARNING_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleManagementUi.rulesTable.mlJobsWarning.popover.description', {
  defaultMessage: 'The following jobs are not running and might cause the rule to generate wrong results:'
});
const ML_RULE_JOBS_WARNING_BUTTON_LABEL = exports.ML_RULE_JOBS_WARNING_BUTTON_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleManagementUi.rulesTable.mlJobsWarning.popover.buttonLabel', {
  defaultMessage: 'Visit rule details page to investigate'
});
const INSTALLED_RULES_TAB = exports.INSTALLED_RULES_TAB = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleManagementUi.rulesTable.allRules.tabs.rules', {
  defaultMessage: `Installed Rules`
});
const RULE_MONITORING_TAB = exports.RULE_MONITORING_TAB = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleManagementUi.rulesTable.allRules.tabs.monitoring', {
  defaultMessage: 'Rule Monitoring'
});
const RULE_UPDATES_TAB = exports.RULE_UPDATES_TAB = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleManagementUi.rulesTable.allRules.tabs.updates', {
  defaultMessage: 'Rule Updates'
});
const SELECTED_RULES = exports.SELECTED_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleManagementUi.rulesTable.allRules.selectedRules', {
  defaultMessage: 'Selected rules'
});

// Gap status column
const GAP_STATUS_HEADER = exports.GAP_STATUS_HEADER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.columns.gapStatus.header', {
  defaultMessage: 'Gap fill status'
});
const GAP_STATUS_IN_PROGRESS_LABEL = exports.GAP_STATUS_IN_PROGRESS_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.columns.gapStatus.inProgress', {
  defaultMessage: 'In progress'
});
const GAP_STATUS_UNFILLED_LABEL = exports.GAP_STATUS_UNFILLED_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.columns.gapStatus.unfilled', {
  defaultMessage: 'Unfilled'
});
const GAP_STATUS_FILLED_LABEL = exports.GAP_STATUS_FILLED_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.columns.gapStatus.filled', {
  defaultMessage: 'Filled'
});
const gapStatusTooltipInProgress = duration => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.columns.gapStatus.tooltip.inProgress', {
  defaultMessage: 'In progress: {duration}',
  values: {
    duration
  }
});
exports.gapStatusTooltipInProgress = gapStatusTooltipInProgress;
const gapStatusTooltipUnfilled = duration => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.columns.gapStatus.tooltip.unfilled', {
  defaultMessage: 'Unfilled: {duration}',
  values: {
    duration
  }
});
exports.gapStatusTooltipUnfilled = gapStatusTooltipUnfilled;
const gapStatusTooltipFilled = duration => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.columns.gapStatus.tooltip.filled', {
  defaultMessage: 'Filled: {duration}',
  values: {
    duration
  }
});
exports.gapStatusTooltipFilled = gapStatusTooltipFilled;