"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlJobCompatibilityCalloutBody = exports.ML_JOB_COMPATIBILITY_CALLOUT_TITLE = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _links_to_docs = require("../../../../common/components/links_to_docs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/ml_job_compatibility_callout/translations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ML_JOB_COMPATIBILITY_CALLOUT_TITLE = exports.ML_JOB_COMPATIBILITY_CALLOUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.mlJobCompatibilityCallout.messageTitle', {
  defaultMessage: 'Your ML jobs may be incompatible with your data sources and/or ML rules'
});
const MlJobCompatibilityCalloutBody = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.mlJobCompatibilityCallout.messageBody",
  defaultMessage: "{summary} Related documentation: {docs}",
  values: {
    summary: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.mlJobCompatibilityCallout.messageBody.summary",
      defaultMessage: "Machine learning rules use ML jobs that in turn have dependencies on data fields populated by the Beats and Elastic Agent integrations that were current when the ML job was created. New ML jobs, prefixed with V3, have been released to operate on now-current ECS fields. If you're using multiple versions of Beats or Elastic Agent, you may need to duplicate or create new machine learning rules that specify the new ML (V3) jobs and enable them to run alongside your existing rules, to ensure continued rule coverage using V1/V2 jobs.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 11
      }
    })),
    docs: /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("li", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_links_to_docs.MlJobCompatibilityLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 13
      }
    })))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 21,
    columnNumber: 3
  }
});
exports.MlJobCompatibilityCalloutBody = MlJobCompatibilityCalloutBody;