"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldUpgrade = FieldUpgrade;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _split_accordion = require("../../../../../../common/components/split_accordion");
var _field_comparison_side = require("../comparison_side/field_comparison_side");
var _field_final_side = require("../field_final_side");
var _field_upgrade_header = require("./field_upgrade_header");
var _field_upgrade_context = require("./field_upgrade_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/rule_upgrade/field_upgrade.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FieldUpgrade() {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    fieldName,
    fieldUpgradeState,
    hasConflict,
    isCustomized
  } = (0, _field_upgrade_context.useFieldUpgradeContext)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_split_accordion.SplitAccordion, {
    header: /*#__PURE__*/_react.default.createElement(_field_upgrade_header.FieldUpgradeHeader, {
      fieldName: fieldName,
      fieldUpgradeState: fieldUpgradeState,
      isCustomized: isCustomized,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 11
      }
    }),
    initialIsOpen: hasConflict,
    "data-test-subj": `${(0, _lodash.snakeCase)(fieldName)}-upgrade`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "flexStart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_field_comparison_side.FieldComparisonSide, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    css: (0, _css.css)`
              align-self: stretch;
              border-right: ${euiTheme.border.thin};
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_field_final_side.FieldFinalSide, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }));
}