"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatMatchQueryEditForm = ThreatMatchQueryEditForm;
var _react = _interopRequireDefault(require("react"));
var _detection_engine = require("../../../../../../../../../common/api/detection_engine");
var _field_final_side = require("../../../field_final_side");
var _threat_match_query_edit_adapter = require("./threat_match_query_edit_adapter");
var _helpers = require("../../../../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/threat_match_query/threat_match_query_edit_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ThreatMatchQueryEditForm() {
  return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
    component: _threat_match_query_edit_adapter.ThreatMatchQueryEditAdapter,
    ruleFieldFormSchema: schema,
    deserializer: deserializer,
    serializer: serializer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  });
}
const schema = {};
function deserializer(_, finalDiffableRule) {
  const parsedQuery = _detection_engine.InlineKqlQuery.parse(finalDiffableRule.threat_query);
  return {
    threatQuery: {
      query: {
        query: parsedQuery.query,
        language: parsedQuery.language
      },
      filters: (0, _helpers.isFilters)(parsedQuery.filters) ? parsedQuery.filters : [],
      saved_id: null
    }
  };
}
function serializer(formData) {
  const threatQuery = formData.threatQuery;
  const query = _detection_engine.RuleQuery.parse(threatQuery.query.query);
  const language = _detection_engine.KqlQueryLanguage.parse(threatQuery.query.language);
  return {
    threat_query: {
      type: _detection_engine.KqlQueryType.inline_query,
      query,
      language,
      filters: threatQuery.filters
    }
  };
}