"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldFinalSideHeader = FieldFinalSideHeader;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _field_upgrade_side_header = require("../../field_upgrade_side_header");
var _utility_types = require("../../../../../../../../common/utility_types");
var _field_upgrade_context = require("../../rule_upgrade/field_upgrade_context");
var _field_edit_form_context = require("../context/field_edit_form_context");
var _field_final_side_help_info = require("./field_final_side_help_info");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/field_final_side/components/field_final_side_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FieldFinalSideHeader() {
  const {
    fieldName,
    hasConflict,
    rightSideMode,
    finalDiffableRule,
    setRuleFieldResolvedValue
  } = (0, _field_upgrade_context.useFieldUpgradeContext)();
  const {
    form
  } = (0, _field_edit_form_context.useFieldEditFormContext)();
  const handleAccept = (0, _react.useCallback)(() => setRuleFieldResolvedValue({
    ruleId: finalDiffableRule.rule_id,
    fieldName: fieldName,
    resolvedValue: finalDiffableRule[fieldName]
  }), [finalDiffableRule, fieldName, setRuleFieldResolvedValue]);
  const handleSave = (0, _react.useCallback)(() => form === null || form === void 0 ? void 0 : form.submit(), [form]);
  switch (rightSideMode) {
    case _field_upgrade_context.FieldFinalSideMode.Readonly:
      return /*#__PURE__*/_react.default.createElement(_field_upgrade_side_header.FieldUpgradeSideHeader, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(StaticHeaderContent, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 11
        }
      }, hasConflict && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconType: "checkInCircleFilled",
        size: "s",
        onClick: handleAccept,
        "data-test-subj": "prebuilt-rule-upgrade-flyout-field-accept",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 15
        }
      }, i18n.ACCEPT)));
    case _field_upgrade_context.FieldFinalSideMode.Edit:
      return /*#__PURE__*/_react.default.createElement(_field_upgrade_side_header.FieldUpgradeSideHeader, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(StaticHeaderContent, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconType: "checkInCircleFilled",
        size: "s",
        disabled: !(form !== null && form !== void 0 && form.isValid),
        onClick: handleSave,
        "data-test-subj": "prebuilt-rule-upgrade-flyout-field-save",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 13
        }
      }, hasConflict ? i18n.SAVE_AND_ACCEPT : i18n.SAVE)));
    default:
      return (0, _utility_types.assertUnreachable)(rightSideMode);
  }
}
function StaticHeaderContent({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "stretch",
    justifyContent: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }, i18n.FINAL_UPDATE, /*#__PURE__*/_react.default.createElement(_field_final_side_help_info.FieldFinalSideHelpInfo, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, children));
}