"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOverviewTabSections = exports.RuleOverviewTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _rule_about_section = require("./rule_about_section");
var _rule_definition_section = require("./rule_definition_section");
var _rule_schedule_section = require("./rule_schedule_section");
var _rule_setup_guide_section = require("./rule_setup_guide_section");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/rule_overview_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultOverviewOpenSections = {
  about: true,
  definition: true,
  schedule: true,
  setup: true
};
const useOverviewTabSections = () => {
  const [expandedOverviewSections, setOpenOverviewSections] = (0, _react.useState)(defaultOverviewOpenSections);
  const toggleSection = (0, _react.useCallback)(sectionName => {
    setOpenOverviewSections(prevOpenSections => ({
      ...prevOpenSections,
      [sectionName]: !prevOpenSections[sectionName]
    }));
  }, []);
  const toggleOverviewSection = (0, _react.useMemo)(() => ({
    about: () => toggleSection('about'),
    definition: () => toggleSection('definition'),
    schedule: () => toggleSection('schedule'),
    setup: () => toggleSection('setup')
  }), [toggleSection]);
  return {
    expandedOverviewSections,
    toggleOverviewSection
  };
};
exports.useOverviewTabSections = useOverviewTabSections;
const ExpandableSection = ({
  title,
  isOpen,
  toggle,
  children
}) => {
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'accordion'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    forceState: isOpen ? 'open' : 'closed',
    onToggle: toggle,
    paddingSize: "none",
    id: accordionId,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }, title)),
    initialIsOpen: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, children));
};
const RuleOverviewTab = ({
  rule,
  columnWidths = _constants.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
  expandedOverviewSections,
  toggleOverviewSection
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(ExpandableSection, {
    title: i18n.ABOUT_SECTION_LABEL,
    isOpen: expandedOverviewSections.about,
    toggle: toggleOverviewSection.about,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, rule.description && /*#__PURE__*/_react.default.createElement(_rule_about_section.Description, {
    description: rule.description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 30
    }
  }), /*#__PURE__*/_react.default.createElement(_rule_about_section.RuleAboutSection, {
    rule: rule,
    columnWidths: columnWidths,
    hideDescription: true,
    hideName: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(ExpandableSection, {
    title: i18n.DEFINITION_SECTION_LABEL,
    isOpen: expandedOverviewSections.definition,
    toggle: toggleOverviewSection.definition,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_definition_section.RuleDefinitionSection, {
    rule: rule,
    columnWidths: columnWidths,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(ExpandableSection, {
    title: i18n.SCHEDULE_SECTION_LABEL,
    isOpen: expandedOverviewSections.schedule,
    toggle: toggleOverviewSection.schedule,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_schedule_section.RuleScheduleSection, {
    rule: rule,
    columnWidths: columnWidths,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  })), rule.setup && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(ExpandableSection, {
    title: i18n.SETUP_GUIDE_SECTION_LABEL,
    isOpen: expandedOverviewSections.setup,
    toggle: toggleOverviewSection.setup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_setup_guide_section.RuleSetupGuideSection, {
    setup: rule.setup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 13
    }
  }))));
};
exports.RuleOverviewTab = RuleOverviewTab;