"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesWithGapsOverviewPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var _rules_table_context = require("../../../rule_management_ui/components/rules_table/rules_table/rules_table_context");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_get_rule_ids_with_gaps = require("../../api/hooks/use_get_rule_ids_with_gaps");
var _constants = require("../../constants");
var _gap_auto_fill_status = require("./gap_auto_fill_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_gaps/components/rules_with_gaps_overview_panel/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RulesWithGapsOverviewPanel = () => {
  var _totalRulesWithGaps$t, _totalRulesWithGaps$t2, _inProgressRulesWithG;
  const {
    state: {
      lastUpdated: rulesTableLastUpdatedAt
    }
  } = (0, _rules_table_context.useRulesTableContext)();
  // Total rules with gaps: unfilled or in progress
  const {
    data: totalRulesWithGaps,
    refetch: refetchGetRuleIdsWithGaps
  } = (0, _use_get_rule_ids_with_gaps.useGetRuleIdsWithGaps)({
    gapRange: _constants.defaultRangeValue,
    gapFillStatuses: [_common.gapFillStatus.UNFILLED, _common.gapFillStatus.IN_PROGRESS]
  });

  // Rules with in-progress gaps
  const {
    data: inProgressRulesWithGaps,
    refetch: refetchGetRuleIdsWithGapsInProgressIntervals
  } = (0, _use_get_rule_ids_with_gaps.useGetRuleIdsWithGaps)({
    gapRange: _constants.defaultRangeValue,
    gapFillStatuses: [_common.gapFillStatus.IN_PROGRESS]
  });
  (0, _react.useEffect)(() => {
    refetchGetRuleIdsWithGaps();
    refetchGetRuleIdsWithGapsInProgressIntervals();
  }, [rulesTableLastUpdatedAt, refetchGetRuleIdsWithGaps, refetchGetRuleIdsWithGapsInProgressIntervals]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "m",
    "data-test-subj": "rule-with-gaps_overview-panel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 17
    }
  }, i18n.RULE_GAPS_OVERVIEW_PANEL_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: i18n.RULE_GAPS_OVERVIEW_PANEL_TOOLTIP_TEXT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    color: ((_totalRulesWithGaps$t = totalRulesWithGaps === null || totalRulesWithGaps === void 0 ? void 0 : totalRulesWithGaps.total) !== null && _totalRulesWithGaps$t !== void 0 ? _totalRulesWithGaps$t : 0) === 0 ? 'success' : 'warning',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 17
    }
  }, (_totalRulesWithGaps$t2 = totalRulesWithGaps === null || totalRulesWithGaps === void 0 ? void 0 : totalRulesWithGaps.total) !== null && _totalRulesWithGaps$t2 !== void 0 ? _totalRulesWithGaps$t2 : 0, " ", '/', " ", (_inProgressRulesWithG = inProgressRulesWithGaps === null || inProgressRulesWithGaps === void 0 ? void 0 : inProgressRulesWithGaps.total) !== null && _inProgressRulesWithG !== void 0 ? _inProgressRulesWithG : 0))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_gap_auto_fill_status.GapAutoFillStatus, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }))));
};
exports.RulesWithGapsOverviewPanel = RulesWithGapsOverviewPanel;