"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateGapAutoFillScheduler = exports.useGetGapAutoFillScheduler = exports.useFindGapAutoFillSchedulerLogs = exports.useCreateGapAutoFillScheduler = void 0;
var _reactQuery = require("@kbn/react-query");
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _constants = require("@kbn/security-solution-features/constants");
var _use_space_id = require("../../../../common/hooks/use_space_id");
var _api = require("../api");
var _constants2 = require("../../constants");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformGapAutoFillSchedulerResponseBody = response => {
  return {
    id: response.id,
    name: response.name,
    enabled: response.enabled,
    gapFillRange: response.gap_fill_range,
    maxBackfills: response.max_backfills,
    numRetries: response.num_retries,
    schedule: {
      interval: response.schedule.interval
    },
    scope: response.scope,
    ruleTypes: response.rule_types,
    createdBy: response.created_by,
    updatedBy: response.updated_by,
    createdAt: response.created_at,
    updatedAt: response.updated_at
  };
};
const getSchedulerId = spaceId => spaceId ? `${_constants2.DEFAULT_GAP_AUTO_FILL_SCHEDULER_ID_PREFIX}-${spaceId}` : 'default';
const useGetGapAutoFillScheduler = options => {
  var _options$enabled;
  const enabled = (_options$enabled = options === null || options === void 0 ? void 0 : options.enabled) !== null && _options$enabled !== void 0 ? _options$enabled : true;
  const spaceId = (0, _use_space_id.useSpaceId)();
  const schedulerId = getSchedulerId(spaceId);
  return (0, _reactQuery.useQuery)(['GET', 'gap_auto_fill_scheduler', schedulerId], async ({
    signal
  }) => {
    const response = await (0, _api.getGapAutoFillScheduler)({
      id: schedulerId,
      signal
    });
    return transformGapAutoFillSchedulerResponseBody(response);
  }, {
    enabled,
    refetchOnWindowFocus: false,
    retry: false
  });
};
exports.useGetGapAutoFillScheduler = useGetGapAutoFillScheduler;
const useCreateGapAutoFillScheduler = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const spaceId = (0, _use_space_id.useSpaceId)();
  const schedulerId = getSchedulerId(spaceId);
  return (0, _reactQuery.useMutation)(async () => {
    const fullBody = {
      id: schedulerId,
      name: '',
      enabled: true,
      gapFillRange: _constants2.DEFAULT_GAP_AUTO_FILL_SCHEDULER_GAP_FILL_RANGE,
      ruleTypes: _securitysolutionRules.SECURITY_SOLUTION_RULE_TYPE_IDS.map(typeId => ({
        type: typeId,
        consumer: _constants.SERVER_APP_ID
      })),
      schedule: {
        interval: _constants2.DEFAULT_GAP_AUTO_FILL_SCHEDULER_INTERVAL
      },
      maxBackfills: _constants2.DEFAULT_GAP_AUTO_FILL_SCHEDULER_MAX_BACKFILLS,
      numRetries: _constants2.DEFAULT_GAP_AUTO_FILL_SCHEDULER_NUM_RETRIES,
      scope: _constants2.DEFAULT_GAP_AUTO_FILL_SCHEDULER_SCOPE
    };
    const response = await (0, _api.createGapAutoFillScheduler)(fullBody);
    return transformGapAutoFillSchedulerResponseBody(response);
  }, {
    mutationKey: ['POST', 'gap_auto_fill_scheduler'],
    onSettled: () => {
      queryClient.invalidateQueries(['GET', 'gap_auto_fill_scheduler', schedulerId]);
    }
  });
};
exports.useCreateGapAutoFillScheduler = useCreateGapAutoFillScheduler;
const useUpdateGapAutoFillScheduler = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const spaceId = (0, _use_space_id.useSpaceId)();
  const schedulerId = getSchedulerId(spaceId);
  return (0, _reactQuery.useMutation)(body => (0, _api.updateGapAutoFillScheduler)(body), {
    mutationKey: ['PUT', 'gap_auto_fill_scheduler', schedulerId],
    onSettled: () => {
      queryClient.invalidateQueries(['GET', 'gap_auto_fill_scheduler', schedulerId]);
    }
  });
};
exports.useUpdateGapAutoFillScheduler = useUpdateGapAutoFillScheduler;
const useFindGapAutoFillSchedulerLogs = ({
  page,
  perPage,
  sortField,
  sortDirection,
  statuses,
  enabled
}) => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  const schedulerId = getSchedulerId(spaceId);
  const {
    start,
    end
  } = (0, _utils.getGapRange)(_constants2.defaultRangeValue);
  return (0, _reactQuery.useQuery)(['GET', 'gap_auto_fill_scheduler_logs', schedulerId, page, perPage, sortField, sortDirection, ...statuses], async ({
    signal
  }) => {
    var _response$data;
    const response = await (0, _api.findGapAutoFillSchedulerLogs)({
      id: schedulerId,
      signal,
      start,
      end,
      page,
      perPage,
      sortField,
      sortDirection,
      statuses
    });
    return {
      data: response === null || response === void 0 ? void 0 : (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.map(log => {
        var _log$results;
        return {
          id: log.id,
          timestamp: log.timestamp,
          status: log.status,
          message: log.message,
          results: (_log$results = log.results) === null || _log$results === void 0 ? void 0 : _log$results.map(result => ({
            ruleId: result.rule_id,
            processedGaps: result.processed_gaps,
            status: result.status,
            error: result.error
          }))
        };
      }),
      total: response.total,
      page: response.page,
      perPage: response.per_page
    };
  }, {
    enabled
  });
};
exports.useFindGapAutoFillSchedulerLogs = useFindGapAutoFillSchedulerLogs;