"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewLogs = exports.CalloutGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _logged_requests = require("./logged_requests");
var _use_accordion_styling = require("./use_accordion_styling");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/rule_preview/preview_logs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CustomWarning = ({
  message
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  color: 'warning',
  iconType: "warning",
  "data-test-subj": 'preview-abort',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 7
  }
}, message)));
const addLogs = (startedAt, logs, duration, allLogs) => logs.length ? [{
  startedAt,
  logs,
  duration
}, ...allLogs] : allLogs;
const PreviewLogsComponent = ({
  logs,
  hasNoiseWarning,
  isAborted,
  showElasticsearchRequests,
  ruleType
}) => {
  const sortedLogs = (0, _react.useMemo)(() => logs.reduce(({
    errors,
    warnings
  }, curr) => ({
    errors: addLogs(curr.startedAt, curr.errors, curr.duration, errors),
    warnings: addLogs(curr.startedAt, curr.warnings, curr.duration, warnings)
  }), {
    errors: [],
    warnings: []
  }), [logs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), hasNoiseWarning !== null && hasNoiseWarning !== void 0 ? hasNoiseWarning : /*#__PURE__*/_react.default.createElement(CustomWarning, {
    message: i18n.QUERY_PREVIEW_NOISE_WARNING,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 27
    }
  }), /*#__PURE__*/_react.default.createElement(LogAccordion, {
    logs: sortedLogs.errors,
    isError: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(LogAccordion, {
    logs: sortedLogs.warnings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, isAborted ? /*#__PURE__*/_react.default.createElement(CustomWarning, {
    message: i18n.PREVIEW_TIMEOUT_WARNING,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 22
    }
  }) : null), showElasticsearchRequests ? /*#__PURE__*/_react.default.createElement(_logged_requests.LoggedRequests, {
    logs: logs,
    ruleType: ruleType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 36
    }
  }) : null);
};
const PreviewLogs = exports.PreviewLogs = /*#__PURE__*/_react.default.memo(PreviewLogsComponent);
PreviewLogs.displayName = 'PreviewLogs';
const LogAccordion = ({
  logs,
  isError,
  children
}) => {
  const cssStyles = (0, _use_accordion_styling.useAccordionStyling)();
  const firstLog = logs[0];
  if (!(children || firstLog)) return null;
  const restOfLogs = children ? logs : logs.slice(1);
  const bannerElement = children !== null && children !== void 0 ? children : /*#__PURE__*/_react.default.createElement(CalloutGroup, {
    logs: firstLog.logs,
    startedAt: firstLog.startedAt,
    isError: isError,
    duration: firstLog.duration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, bannerElement, restOfLogs.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: isError ? 'previewErrorAccordion' : 'previewWarningAccordion',
    buttonContent: isError ? i18n.QUERY_PREVIEW_SEE_ALL_ERRORS : i18n.QUERY_PREVIEW_SEE_ALL_WARNINGS,
    borders: "horizontal",
    css: (0, _css.css)`
            ${cssStyles}
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, restOfLogs.map((log, key) => /*#__PURE__*/_react.default.createElement(CalloutGroup, {
    key: `accordion-log-${key}`,
    logs: log.logs,
    startedAt: log.startedAt,
    duration: log.duration,
    isError: isError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }))) : null);
};
const CalloutGroup = ({
  logs,
  startedAt,
  isError,
  duration
}) => {
  return logs.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, logs.map((log, i) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: i,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: isError ? 'danger' : 'warning',
    iconType: "warning",
    "data-test-subj": isError ? 'preview-error' : 'preview-warning',
    title: `${startedAt ? `[${startedAt}] ` : ''}[${duration}ms]`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  }, log))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  })))) : null;
};
exports.CalloutGroup = CalloutGroup;