"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNoisy = exports.getTimeframeOptions = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Determines whether or not to display noise warning.
 * Is considered noisy if alerts/hour rate > 1
 * @param hits Total query search hits
 * @param timeframe Range selected by user (last hour, day...)
 */
const isNoisy = (hits, timeframe) => {
  const oneHour = 1000 * 60 * 60;
  const durationInHours = Math.max((timeframe.timeframeEnd.valueOf() - timeframe.timeframeStart.valueOf()) / oneHour, 1.0);
  return hits / durationInHours > 1;
};

/**
 * Determines what timerange options to show.
 * Eql sequence queries tend to be slower, so decided
 * not to include the last month option.
 * @param ruleType
 */
exports.isNoisy = isNoisy;
const getTimeframeOptions = ruleType => {
  if (ruleType === 'eql') {
    return [{
      value: 'h',
      text: i18n.LAST_HOUR
    }, {
      value: 'd',
      text: i18n.LAST_DAY
    }];
  } else if (ruleType === 'threat_match') {
    return [{
      value: 'h',
      text: i18n.LAST_HOUR
    }, {
      value: 'd',
      text: i18n.LAST_DAY
    }, {
      value: 'w',
      text: i18n.LAST_WEEK
    }];
  } else if (ruleType === 'threshold') {
    return [{
      value: 'h',
      text: i18n.LAST_HOUR
    }];
  } else {
    return [{
      value: 'h',
      text: i18n.LAST_HOUR
    }, {
      value: 'd',
      text: i18n.LAST_DAY
    }, {
      value: 'M',
      text: i18n.LAST_MONTH
    }];
  }
};
exports.getTimeframeOptions = getTimeframeOptions;