"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScheduleBulkActionConfirmation = void 0;
var _react = require("react");
var _use_bool_state = require("../../../../common/hooks/use_bool_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that controls the confirmation modal of a schedule bulk action such as manual run or fill gaps
 */
const useScheduleBulkActionConfirmation = () => {
  const [isScheduleBulkActionConfirmationVisible, showModal, hideModal] = (0, _use_bool_state.useBoolState)();
  const confirmationPromiseRef = (0, _react.useRef)();
  const onConfirm = (0, _react.useCallback)(timerange => {
    var _confirmationPromiseR;
    (_confirmationPromiseR = confirmationPromiseRef.current) === null || _confirmationPromiseR === void 0 ? void 0 : _confirmationPromiseR.call(confirmationPromiseRef, timerange);
  }, []);
  const onCancel = (0, _react.useCallback)(() => {
    var _confirmationPromiseR2;
    (_confirmationPromiseR2 = confirmationPromiseRef.current) === null || _confirmationPromiseR2 === void 0 ? void 0 : _confirmationPromiseR2.call(confirmationPromiseRef, null);
  }, []);
  const initModal = (0, _react.useCallback)(() => {
    showModal();
    return new Promise(resolve => {
      confirmationPromiseRef.current = resolve;
    }).finally(() => {
      hideModal();
    });
  }, [showModal, hideModal]);
  const showScheduleBulkActionConfirmation = (0, _react.useCallback)(async () => {
    const confirmation = await initModal();
    if (confirmation) {
      onConfirm(confirmation);
    } else {
      onCancel();
    }
    return confirmation;
  }, [initModal, onConfirm, onCancel]);
  return {
    isScheduleBulkActionConfirmationVisible,
    showScheduleBulkActionConfirmation,
    cancelScheduleBulkAction: onCancel,
    confirmScheduleBulkAction: onConfirm
  };
};
exports.useScheduleBulkActionConfirmation = useScheduleBulkActionConfirmation;