"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleSwitchComponent = exports.RuleSwitch = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _rule_management = require("../../../../../common/api/detection_engine/rule_management");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _use_execute_bulk_action = require("../../../rule_management/logic/bulk_actions/use_execute_bulk_action");
var _rules_table_context = require("../../../rule_management_ui/components/rules_table/rules_table/rules_table_context");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/common/components/rule_switch/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StaticSwitch = (0, _styledComponents.default)(_eui.EuiSwitch)`
  .euiSwitch__thumb,
  .euiSwitch__icon {
    transition: none;
  }
`;
StaticSwitch.displayName = 'StaticSwitch';
/**
 * Basic switch component for displaying loader when enabled/disabled
 */
const RuleSwitchComponent = ({
  id,
  isDisabled,
  isLoading,
  enabled,
  startMlJobsIfNeeded,
  onChange,
  ruleName
}) => {
  const [myIsLoading, setMyIsLoading] = (0, _react.useState)(false);
  const ariaLabel = ruleName ? (0, _translations.ruleSwitchAriaLabel)(ruleName, enabled) : undefined;
  const rulesTableContext = (0, _rules_table_context.useRulesTableContextOptional)();
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const {
    executeBulkAction
  } = (0, _use_execute_bulk_action.useExecuteBulkAction)({
    suppressSuccessToast: !rulesTableContext
  });
  const onRuleStateChange = (0, _react.useCallback)(async event => {
    setMyIsLoading(true);
    startTransaction({
      name: enabled ? _user_actions.SINGLE_RULE_ACTIONS.DISABLE : _user_actions.SINGLE_RULE_ACTIONS.ENABLE
    });
    const enableRule = event.target.checked;
    if (enableRule) {
      await (startMlJobsIfNeeded === null || startMlJobsIfNeeded === void 0 ? void 0 : startMlJobsIfNeeded());
    }
    const bulkActionResponse = await executeBulkAction({
      type: enableRule ? _rule_management.BulkActionTypeEnum.enable : _rule_management.BulkActionTypeEnum.disable,
      ids: [id]
    });
    if (bulkActionResponse !== null && bulkActionResponse !== void 0 && bulkActionResponse.attributes.results.updated.length) {
      // The rule was successfully updated
      onChange === null || onChange === void 0 ? void 0 : onChange(bulkActionResponse.attributes.results.updated[0].enabled);
    }
    setMyIsLoading(false);
  }, [enabled, executeBulkAction, id, onChange, startMlJobsIfNeeded, startTransaction]);
  const showLoader = (0, _react.useMemo)(() => {
    if (myIsLoading !== isLoading) {
      return isLoading || myIsLoading;
    }
    return myIsLoading;
  }, [myIsLoading, isLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceAround",
    id: `rule-switch-${id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, showLoader ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "data-test-subj": "ruleSwitchLoader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(StaticSwitch, {
    "data-test-subj": "ruleSwitch",
    showLabel: false,
    label: "",
    disabled: isDisabled,
    checked: enabled,
    onChange: onRuleStateChange,
    "aria-label": ariaLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  })));
};
exports.RuleSwitchComponent = RuleSwitchComponent;
const RuleSwitch = exports.RuleSwitch = /*#__PURE__*/_react.default.memo(RuleSwitchComponent);
RuleSwitch.displayName = 'RuleSwitch';