"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardsLinks = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/security-solution-features/constants");
var _constants2 = require("../../common/constants");
var _translations = require("../app/translations");
var _links = require("../kubernetes/links");
var _links2 = require("../cloud_security_posture/links");
var _links3 = require("../overview/links");
var _dashboards = require("../common/icons/dashboards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const subLinks = [_links3.overviewLinks, _links3.detectionResponseLinks, _links.links, _links2.cspDashboardLink, _links2.vulnerabilityDashboardLink, _links3.entityAnalyticsLinks, _links3.ecsDataQualityDashboardLinks].map(link => ({
  ...link,
  sideNavIcon: _dashboards.IconDashboards
}));
const dashboardsLinks = exports.dashboardsLinks = {
  id: _constants2.SecurityPageName.dashboards,
  title: _translations.DASHBOARDS,
  path: _constants2.DASHBOARDS_PATH,
  globalNavPosition: 1,
  capabilities: [[_constants.SECURITY_UI_SHOW_PRIVILEGE, `${_constants2.SECURITY_FEATURE_ID}.detections`]],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.dashboards', {
    defaultMessage: 'Dashboards'
  })],
  links: subLinks,
  skipUrlState: false
};