"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardRenderer = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDashboardRenderer = () => {
  const [dashboardContainer, setDashboardContainer] = (0, _react.useState)();
  const handleDashboardLoaded = (0, _react.useCallback)(container => {
    setDashboardContainer(container);
  }, []);
  return (0, _react.useMemo)(() => ({
    dashboardContainer,
    handleDashboardLoaded
  }), [dashboardContainer, handleDashboardLoaded]);
};
exports.useDashboardRenderer = useDashboardRenderer;