"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AISettingsRouteGuard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _ai_settings = require("../tabs/ai_settings");
var _use_agent_builder_availability = require("../../agent_builder/hooks/use_agent_builder_availability");
var _kibana = require("../../common/lib/kibana");
var _constants = require("../../../common/constants");
var _constants2 = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/configurations/page/ai_settings_route_guard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AISettingsRouteGuard = exports.AISettingsRouteGuard = /*#__PURE__*/_react.default.memo(() => {
  const {
    isAgentChatExperienceEnabled
  } = (0, _use_agent_builder_availability.useAgentBuilderAvailability)();
  const {
    navigateTo
  } = (0, _kibana.useNavigation)();
  (0, _react.useEffect)(() => {
    if (isAgentChatExperienceEnabled) {
      navigateTo({
        deepLinkId: _securitySolutionNavigation.SecurityPageName.configurationsIntegrations
      });
    }
  }, [isAgentChatExperienceEnabled, navigateTo]);
  if (isAgentChatExperienceEnabled) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: `${_constants.CONFIGURATIONS_PATH}/${_constants2.ConfigurationTabs.integrations}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_ai_settings.AISettings, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 10
    }
  });
});
AISettingsRouteGuard.displayName = 'AISettingsRouteGuard';