"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSavedQueryServices = void 0;
var _react = require("react");
var _public = require("@kbn/data-plugin/public");
var _kibana = require("../../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSavedQueryServices = () => {
  const kibana = (0, _kibana.useKibana)();
  const {
    http
  } = kibana.services;
  const [savedQueryService, setSavedQueryService] = (0, _react.useState)((0, _public.createSavedQueryService)(http));
  (0, _react.useEffect)(() => {
    setSavedQueryService((0, _public.createSavedQueryService)(http));
  }, [http]);
  return savedQueryService;
};
exports.useSavedQueryServices = useSavedQueryServices;