"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

jest.mock('@hello-pangea/dnd', () => ({
  Droppable: ({
    children
  }) => children({
    droppableProps: {
      'data-rfd-droppable-context-id': '123',
      'data-rfd-droppable-id': '123'
    },
    innerRef: jest.fn(),
    placeholder: null
  }, {
    isDraggingOver: false,
    draggingOverWith: null,
    draggingFromThisWith: null,
    isUsingPlaceholder: false
  }),
  Draggable: ({
    children
  }) => children({
    draggableProps: {
      'data-rfd-draggable-context-id': '123',
      'data-rfd-draggable-id': '123'
    },
    innerRef: jest.fn(),
    dragHandleProps: null
  }, {
    isDragging: false,
    isDropAnimating: false,
    isClone: false,
    dropAnimation: null,
    draggingOver: null,
    combineWith: null,
    combineTargetFor: null,
    mode: null
  }),
  DragDropContext: ({
    children
  }) => children
}));