"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProductFeatureKeys = void 0;
var _react = require("react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _kibana = require("../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to get the current product feature keys from the observable.
 *
 * @returns Set of product feature keys, or empty Set if not available
 */
const useProductFeatureKeys = () => {
  const {
    productFeatureKeys$
  } = (0, _kibana.useKibana)().services;
  const productFeatureKeys = (0, _useObservable.default)(productFeatureKeys$, null);
  return (0, _react.useMemo)(() => productFeatureKeys !== null && productFeatureKeys !== void 0 ? productFeatureKeys : new Set(), [productFeatureKeys]);
};
exports.useProductFeatureKeys = useProductFeatureKeys;