"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGlobalFilterQuery = void 0;
var _react = require("react");
var _common = require("@kbn/data-plugin/common");
var _esQuery = require("@kbn/es-query");
var _use_global_time = require("../containers/use_global_time");
var _kibana = require("../lib/kibana");
var _store = require("../store");
var _use_selector = require("./use_selector");
var _use_invalid_filter_query = require("./use_invalid_filter_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * It builds a global filterQuery from KQL search bar and global filters.
 * It also validates the query and shows a warning if it's invalid.
 */
const useGlobalFilterQuery = ({
  extraFilter,
  dataView
} = {}) => {
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const filters = (0, _react.useMemo)(() => {
    const enabledFilters = globalFilters.filter(f => f.meta.disabled === false);
    return extraFilter ? [...enabledFilters, extraFilter] : enabledFilters;
  }, [extraFilter, globalFilters]);
  const {
    filterQuery,
    kqlError
  } = (0, _react.useMemo)(() => buildQueryOrError(query, filters, (0, _common.getEsQueryConfig)(uiSettings), dataView), [dataView, query, filters, uiSettings]);
  const filterQueryStringified = (0, _react.useMemo)(() => filterQuery ? JSON.stringify(filterQuery) : undefined, [filterQuery]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: 'GlobalFilterQuery',
    // It prevents displaying multiple times the same error popup
    filterQuery: filterQueryStringified,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  return {
    filterQuery
  };
};
exports.useGlobalFilterQuery = useGlobalFilterQuery;
const buildQueryOrError = (query, filters, config, dataView) => {
  try {
    return {
      filterQuery: (0, _esQuery.buildEsQuery)(dataView, [query], filters, config)
    };
  } catch (kqlError) {
    return {
      kqlError
    };
  }
};