"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsExperimentalFeatureEnabled = void 0;
var _reactRedux = require("react-redux");
var _experimental_features = require("../../../common/experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allowedExperimentalValues = (0, _experimental_features.getExperimentalAllowedValues)();
const useEnableExperimental = () => (0, _reactRedux.useSelector)(({
  app: {
    enableExperimental
  }
}) => enableExperimental);
const useIsExperimentalFeatureEnabled = feature => {
  const enableExperimental = useEnableExperimental();
  if (!enableExperimental || !(feature in enableExperimental)) {
    throw new Error(`Invalid enable value ${feature}. Allowed values are: ${allowedExperimentalValues.join(', ')}`);
  }
  return enableExperimental[feature];
};
exports.useIsExperimentalFeatureEnabled = useIsExperimentalFeatureEnabled;