"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardHref = exports.dashboardRequestBody = void 0;
var _react = require("react");
var _constants = require("../../../common/constants");
var _use_url_state_query_params = require("../components/navigation/use_url_state_query_params");
var _kibana = require("../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dashboardRequestBody = title => ({
  type: 'dashboard',
  search: `"${title}"`,
  fields: ['title']
});
exports.dashboardRequestBody = dashboardRequestBody;
const useDashboardHref = ({
  title
}) => {
  const {
    dashboard
  } = (0, _kibana.useKibana)().services;
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const [dashboardId, setDashboardId] = (0, _react.useState)();
  const params = (0, _use_url_state_query_params.useUrlStateQueryParams)(_constants.SecurityPageName.dashboards);
  (0, _react.useEffect)(() => {
    let ignore = false;
    (async () => {
      if (dashboard && title) {
        var _await$findDashboards;
        const findDashboardsService = await (dashboard === null || dashboard === void 0 ? void 0 : dashboard.findDashboardsService());
        const {
          id
        } = (_await$findDashboards = await findDashboardsService.findByTitle(title)) !== null && _await$findDashboards !== void 0 ? _await$findDashboards : {};
        if (!ignore) {
          setDashboardId(id);
        }
      }
    })();
    return () => {
      ignore = true;
    };
  }, [dashboard, title]);
  return (0, _react.useMemo)(() => {
    if (dashboardId) {
      return getAppUrl({
        deepLinkId: _constants.SecurityPageName.dashboards,
        path: `${dashboardId}${params}`
      });
    } else {
      return undefined;
    }
  }, [dashboardId, getAppUrl, params]);
};
exports.useDashboardHref = useDashboardHref;