"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkAlertAssigneesPanel = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _assignees_apply_panel = require("../../assignees/assignees_apply_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/toolbar/bulk_actions/alert_bulk_assignees.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BulkAlertAssigneesPanelComponent = ({
  alertItems,
  refresh,
  setIsLoading,
  clearSelection,
  closePopoverMenu,
  onSubmit
}) => {
  const alertIds = (0, _react.useMemo)(() => alertItems.map(item => item._id), [alertItems]);
  const assignedUserIds = (0, _react.useMemo)(() => (0, _lodash.intersection)(...alertItems.map(item => {
    var _item$data$find$value, _item$data$find;
    return (_item$data$find$value = (_item$data$find = item.data.find(data => data.field === _ruleDataUtils.ALERT_WORKFLOW_ASSIGNEE_IDS)) === null || _item$data$find === void 0 ? void 0 : _item$data$find.value) !== null && _item$data$find$value !== void 0 ? _item$data$find$value : [];
  })), [alertItems]);
  const onSuccess = (0, _react.useCallback)(() => {
    if (refresh) refresh();
    if (clearSelection) clearSelection();
  }, [clearSelection, refresh]);
  const handleApplyAssignees = (0, _react.useCallback)(async assignees => {
    closePopoverMenu();
    if (onSubmit) {
      closePopoverMenu();
      await onSubmit(assignees, alertIds, onSuccess, setIsLoading);
    }
  }, [alertIds, closePopoverMenu, onSubmit, onSuccess, setIsLoading]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "alert-assignees-selectable-menu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_assignees_apply_panel.AssigneesApplyPanel, {
    assignedUserIds: assignedUserIds,
    onApply: handleApplyAssignees,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }));
};
const BulkAlertAssigneesPanel = exports.BulkAlertAssigneesPanel = /*#__PURE__*/(0, _react.memo)(BulkAlertAssigneesPanelComponent);