"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHostNameFromInfluencers = void 0;
var _get_entries = require("../get_entries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHostNameFromInfluencers = (influencers = [], hostName) => {
  const recordFound = influencers.find(influencer => {
    const [influencerName, influencerValue] = (0, _get_entries.getEntries)(influencer);
    if (influencerName === 'host.name') {
      if (hostName == null) {
        return true;
      } else {
        return influencerValue === hostName;
      }
    } else {
      return false;
    }
  });
  if (recordFound != null) {
    return Object.values(recordFound)[0];
  } else {
    return null;
  }
};
exports.getHostNameFromInfluencers = getHostNameFromInfluencers;