"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isUnknownError = exports.isMlStartJobError = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// use the "in operator" and regular type guards to do a narrow once this issue is fixed below:
// https://github.com/microsoft/TypeScript/issues/21732
// Otherwise for now, has will work ok even though it casts 'unknown' to 'any'
const isMlStartJobError = value => (0, _fp.has)('error.msg', value) && (0, _fp.has)('error.response', value) && (0, _fp.has)('error.statusCode', value);
exports.isMlStartJobError = isMlStartJobError;
const isUnknownError = value => (0, _fp.has)('error.error.reason', value);
exports.isUnknownError = isUnknownError;