"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelpMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _kibana = require("../../lib/kibana");
var _translations = require("../../translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HelpMenu = exports.HelpMenu = /*#__PURE__*/_react.default.memo(() => {
  const {
    chrome,
    docLinks
  } = (0, _kibana.useKibana)().services;
  (0, _react.useEffect)(() => {
    chrome.setHelpExtension({
      appName: _translations.SOLUTION_NAME,
      links: [{
        content: _i18n.i18n.translate('xpack.securitySolution.chrome.helpMenu.documentation', {
          defaultMessage: 'Security documentation'
        }),
        href: docLinks.links.siem.guide,
        iconType: 'documents',
        linkType: 'custom',
        target: '_blank',
        rel: 'noopener'
      }, {
        content: _i18n.i18n.translate('xpack.securitySolution.chrome.helpMenu.documentation.ecs', {
          defaultMessage: 'ECS documentation'
        }),
        href: docLinks.links.ecs.guide,
        iconType: 'documents',
        linkType: 'custom',
        target: '_blank',
        rel: 'noopener'
      }, {
        linkType: 'discuss',
        href: 'https://discuss.elastic.co/c/security',
        target: '_blank',
        rel: 'noopener'
      }]
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return null;
});
HelpMenu.displayName = 'HelpMenu';