"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIconFromType = exports.getExampleText = exports.EVENT_FIELDS_TABLE_CLASS_NAME = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Returns example text, or an empty string if the field does not have an example */
const getExampleText = example => !(0, _fp.isEmpty)(example) ? `Example: ${example}` : '';
exports.getExampleText = getExampleText;
const getIconFromType = type => {
  switch (type) {
    case 'string': // fall through
    case 'keyword':
      return 'string';
    case 'number': // fall through
    case 'long':
      return 'number';
    case 'date':
      return 'clock';
    case 'ip':
    case 'geo_point':
      return 'globe';
    case 'object':
      return 'question';
    case 'float':
      return 'number';
    default:
      return 'question';
  }
};
exports.getIconFromType = getIconFromType;
const EVENT_FIELDS_TABLE_CLASS_NAME = exports.EVENT_FIELDS_TABLE_CLASS_NAME = 'event-fields-table';