"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SECONDS_SCREEN_READER = exports.MINUTES_SCREEN_READER = exports.HOURS_SCREEN_READER = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECONDS_SCREEN_READER = value => _i18n.i18n.translate('xpack.securitySolution.accessibility.intervalAbbrScreenReader.seconds', {
  defaultMessage: '{value} {value, plural, one { second } other { seconds }}',
  values: {
    value
  }
});
exports.SECONDS_SCREEN_READER = SECONDS_SCREEN_READER;
const MINUTES_SCREEN_READER = value => _i18n.i18n.translate('xpack.securitySolution.accessibility.intervalAbbrScreenReader.minutes', {
  defaultMessage: '{value} {value, plural, one { minute } other { minutes }}',
  values: {
    value
  }
});
exports.MINUTES_SCREEN_READER = MINUTES_SCREEN_READER;
const HOURS_SCREEN_READER = value => _i18n.i18n.translate('xpack.securitySolution.accessibility.intervalAbbrScreenReader.hours', {
  defaultMessage: '{value} {value, plural, one { hour } other { hours }}',
  values: {
    value
  }
});
exports.HOURS_SCREEN_READER = HOURS_SCREEN_READER;