"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateBreadcrumbsNav = exports.breadcrumbsNav$ = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Used to update the breadcrumbsNav$ observable internally.
const breadcrumbsNavUpdater$ = new _rxjs.BehaviorSubject({
  leading: [],
  trailing: []
});

// The observable can be exposed by the plugin contract.
const breadcrumbsNav$ = exports.breadcrumbsNav$ = breadcrumbsNavUpdater$.asObservable();
const updateBreadcrumbsNav = breadcrumbsNav => {
  breadcrumbsNavUpdater$.next(breadcrumbsNav);
};
exports.updateBreadcrumbsNav = updateBreadcrumbsNav;