"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDismissAttackDiscoveryGeneration = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _shared = require("@kbn/openapi-common/shared");
var _reactQuery = require("@kbn/react-query");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _kibana = require("../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_get_attack_discovery_generations = require("../use_get_attack_discovery_generations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Disables the attack discovery schedule. */

const useDismissAttackDiscoveryGeneration = () => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const invalidateGetAttackDiscoveryGenerations = (0, _use_get_attack_discovery_generations.useInvalidateGetAttackDiscoveryGenerations)();
  const dismiss = async ({
    executionUuid,
    signal
  }) => _kibana.KibanaServices.get().http.post((0, _shared.replaceParams)(_elasticAssistantCommon.ATTACK_DISCOVERY_GENERATIONS_BY_ID_DISMISS, {
    execution_uuid: executionUuid
  }), {
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    signal
  });
  return (0, _reactQuery.useMutation)(({
    executionUuid
  }) => dismiss({
    executionUuid
  }), {
    mutationKey: ['POST', _elasticAssistantCommon.ATTACK_DISCOVERY_GENERATIONS_BY_ID_DISMISS],
    onSuccess: () => {
      invalidateGetAttackDiscoveryGenerations();
    },
    onError: error => {
      addError(error, {
        title: i18n.DISMISS_ATTACK_DISCOVERY_GENERATIONS_FAILURE()
      });
    }
  });
};
exports.useDismissAttackDiscoveryGeneration = useDismissAttackDiscoveryGeneration;