"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAttackDiscovery = void 0;
var _elasticAssistant = require("@kbn/elastic-assistant");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _fp = require("lodash/fp");
var _react = require("react");
var _use_fetch_anonymization_fields = require("@kbn/elastic-assistant/impl/assistant/api/anonymization_fields/use_fetch_anonymization_fields");
var _kibana = require("../../../common/lib/kibana");
var _helpers = require("../helpers");
var _helpers2 = require("./helpers");
var _translations = require("../translations");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_get_attack_discovery_generations = require("../use_get_attack_discovery_generations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAttackDiscovery = ({
  connectorId,
  connectorName,
  size,
  setLoadingConnectorId
}) => {
  // get Kibana services and connectors
  const {
    http,
    notifications: {
      toasts
    },
    settings
  } = (0, _kibana.useKibana)().services;
  const {
    data: aiConnectors
  } = (0, _elasticAssistant.useLoadConnectors)({
    http,
    settings
  });

  // loading boilerplate:
  const [isLoading, setIsLoading] = (0, _react.useState)(false);

  // get alerts index pattern and allow lists from the assistant context:
  const {
    alertsIndexPattern,
    traceOptions
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    data: anonymizationFields
  } = (0, _use_fetch_anonymization_fields.useFetchAnonymizationFields)();
  const invalidateGetAttackDiscoveryGenerations = (0, _use_get_attack_discovery_generations.useInvalidateGetAttackDiscoveryGenerations)();

  /** The callback when users click the Generate button */
  const fetchAttackDiscoveries = (0, _react.useCallback)(async options => {
    try {
      var _ref, _options$overrideSize, _options$overrideEnd, _options$overrideFilt, _options$overrideStar, _options$overrideConn, _effectiveConnector$n, _effectiveConnector$n2;
      const effectiveSize = (_ref = (_options$overrideSize = options === null || options === void 0 ? void 0 : options.overrideSize) !== null && _options$overrideSize !== void 0 ? _options$overrideSize : options === null || options === void 0 ? void 0 : options.size) !== null && _ref !== void 0 ? _ref : size;
      const effectiveEnd = (_options$overrideEnd = options === null || options === void 0 ? void 0 : options.overrideEnd) !== null && _options$overrideEnd !== void 0 ? _options$overrideEnd : options === null || options === void 0 ? void 0 : options.end;
      const effectiveFilter = (_options$overrideFilt = options === null || options === void 0 ? void 0 : options.overrideFilter) !== null && _options$overrideFilt !== void 0 ? _options$overrideFilt : !(0, _fp.isEmpty)(options === null || options === void 0 ? void 0 : options.filter) ? options === null || options === void 0 ? void 0 : options.filter : undefined;
      const effectiveStart = (_options$overrideStar = options === null || options === void 0 ? void 0 : options.overrideStart) !== null && _options$overrideStar !== void 0 ? _options$overrideStar : options === null || options === void 0 ? void 0 : options.start;
      const effectiveConnectorId = (_options$overrideConn = options === null || options === void 0 ? void 0 : options.overrideConnectorId) !== null && _options$overrideConn !== void 0 ? _options$overrideConn : connectorId;

      // Get the request body with the effective connector ID
      const effectiveConnector = aiConnectors === null || aiConnectors === void 0 ? void 0 : aiConnectors.find(connector => connector.id === effectiveConnectorId);
      const effectiveGenAiConfig = (0, _helpers2.getGenAiConfig)(effectiveConnector);
      const effectiveRequestBody = (0, _helpers2.getRequestBody)({
        alertsIndexPattern,
        anonymizationFields,
        genAiConfig: effectiveGenAiConfig,
        size,
        selectedConnector: effectiveConnector,
        traceOptions
      });
      const bodyWithOverrides = {
        ...effectiveRequestBody,
        connectorName: (_effectiveConnector$n = effectiveConnector === null || effectiveConnector === void 0 ? void 0 : effectiveConnector.name) !== null && _effectiveConnector$n !== void 0 ? _effectiveConnector$n : connectorName,
        end: effectiveEnd,
        filter: effectiveFilter,
        size: effectiveSize,
        start: effectiveStart
      };
      if (bodyWithOverrides.apiConfig.connectorId === '' || bodyWithOverrides.apiConfig.actionTypeId === '') {
        throw new Error(_translations.CONNECTOR_ERROR);
      }
      setLoadingConnectorId === null || setLoadingConnectorId === void 0 ? void 0 : setLoadingConnectorId(effectiveConnectorId !== null && effectiveConnectorId !== void 0 ? effectiveConnectorId : null);

      // call the API to generate attack discoveries:
      const rawResponse = await http.post(_elasticAssistantCommon.ATTACK_DISCOVERY_GENERATE, {
        body: JSON.stringify(bodyWithOverrides),
        version: _elasticAssistantCommon.API_VERSIONS.public.v1
      });
      const parsedResponse = _elasticAssistantCommon.PostAttackDiscoveryGenerateResponse.safeParse(rawResponse);
      if (!parsedResponse.success) {
        throw new Error('Failed to parse the response');
      }
      toasts === null || toasts === void 0 ? void 0 : toasts.addSuccess({
        title: i18n.GENERATION_STARTED_TITLE,
        text: i18n.GENERATION_STARTED_TEXT((_effectiveConnector$n2 = effectiveConnector === null || effectiveConnector === void 0 ? void 0 : effectiveConnector.name) !== null && _effectiveConnector$n2 !== void 0 ? _effectiveConnector$n2 : connectorName)
      });
    } catch (error) {
      setIsLoading(false);
      toasts === null || toasts === void 0 ? void 0 : toasts.addDanger(error, {
        title: _translations.ERROR_GENERATING_ATTACK_DISCOVERIES,
        text: (0, _helpers.getErrorToastText)(error)
      });
    } finally {
      invalidateGetAttackDiscoveryGenerations();
    }
  }, [aiConnectors, alertsIndexPattern, anonymizationFields, connectorId, connectorName, http, invalidateGetAttackDiscoveryGenerations, setLoadingConnectorId, size, toasts, traceOptions]);
  return {
    fetchAttackDiscoveries,
    isLoading
  };
};
exports.useAttackDiscovery = useAttackDiscovery;