"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_ALERTS_ASSOCIATED = exports.UPDATE_ALERTS = exports.MARK_DISCOVERIES_ONLY = exports.MARK_ALERTS_AND_DISCOVERIES = exports.CANCEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.takeAction.confirmModal.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});
const MARK_ALERTS_AND_DISCOVERIES = ({
  alertsCount,
  attackDiscoveriesCount,
  workflowStatus
}) => {
  return _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.takeAction.confirmModal.markDiscoveriesAndAlertsButtonLabel', {
    defaultMessage: 'Mark {alertsCount, plural, =1 {alert} other {alerts}} & {attackDiscoveriesCount, plural, =1 {discovery} other {discoveries}} as {workflowStatus}',
    values: {
      alertsCount,
      attackDiscoveriesCount,
      workflowStatus
    }
  });
};
exports.MARK_ALERTS_AND_DISCOVERIES = MARK_ALERTS_AND_DISCOVERIES;
const MARK_DISCOVERIES_ONLY = ({
  attackDiscoveriesCount,
  workflowStatus
}) => {
  return _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.takeAction.confirmModal.markDiscoveriesOnlyButtonLabel', {
    defaultMessage: 'Mark {attackDiscoveriesCount, plural, =1 {discovery} other {discoveries}} as {workflowStatus}',
    values: {
      attackDiscoveriesCount,
      workflowStatus
    }
  });
};
exports.MARK_DISCOVERIES_ONLY = MARK_DISCOVERIES_ONLY;
const UPDATE_ALERTS = exports.UPDATE_ALERTS = _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.takeAction.confirmModal.updateAlertsTitle', {
  defaultMessage: 'Update alerts?'
});
const UPDATE_ALERTS_ASSOCIATED = ({
  alertsCount,
  attackDiscoveriesCount
}) => {
  return _i18n.i18n.translate('xpack.securitySolution.attackDiscovery.results.takeAction.confirmModal.updateAlertsAssociatedModalBody', {
    defaultMessage: 'Update {alertsCount} alerts associated with {attackDiscoveriesCount, plural, =1 {the attack discovery} other {{attackDiscoveriesCount} attack discoveries}}?',
    values: {
      alertsCount,
      attackDiscoveriesCount
    }
  });
};
exports.UPDATE_ALERTS_ASSOCIATED = UPDATE_ALERTS_ASSOCIATED;