"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectIfUnauthorized = RedirectIfUnauthorized;
var _react = _interopRequireDefault(require("react"));
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _managementSettingsIds = require("@kbn/management-settings-ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RedirectIfUnauthorized({
  coreStart,
  children
}) {
  var _capabilities$securit, _capabilities$securit2;
  const {
    application: {
      capabilities,
      navigateToApp
    }
  } = coreStart;
  const chatExperience = coreStart.settings.client.get(_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE, _aiAssistantCommon.AIChatExperience.Classic);
  const securityAIAssistantEnabled = (_capabilities$securit = capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$securit2 = capabilities.securitySolutionAssistant) === null || _capabilities$securit2 === void 0 ? void 0 : _capabilities$securit2['ai-assistant']) !== null && _capabilities$securit !== void 0 ? _capabilities$securit : false;
  const allowed = securityAIAssistantEnabled && chatExperience !== _aiAssistantCommon.AIChatExperience.Agent;
  if (!allowed) {
    navigateToApp('home');
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
}