"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertDetailsUrl = exports.buildAlertDetailPath = void 0;
var _common = require("@kbn/spaces-plugin/common");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildAlertDetailPath = ({
  alertId,
  index,
  timestamp
}) => `${_constants.ALERT_DETAILS_REDIRECT_PATH}/${alertId}?index=${index}&timestamp=${timestamp}`;
exports.buildAlertDetailPath = buildAlertDetailPath;
const getAlertDetailsUrl = ({
  alertId,
  index,
  timestamp,
  basePath,
  spaceId
}) => {
  const alertDetailPath = buildAlertDetailPath({
    alertId,
    index,
    timestamp
  });
  const alertDetailPathWithAppPath = `${_constants.APP_PATH}${alertDetailPath}`;
  return basePath ? (0, _common.addSpaceIdToPath)(basePath, spaceId !== null && spaceId !== void 0 ? spaceId : undefined, alertDetailPathWithAppPath) : undefined;
};
exports.getAlertDetailsUrl = getAlertDetailsUrl;