"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegacyEntityType = exports.EntityTypeToIdentifierField = exports.EntityType = exports.EntityIdentifierFields = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Use exclusively for the legacy risk score module
let LegacyEntityType = exports.LegacyEntityType = /*#__PURE__*/function (LegacyEntityType) {
  LegacyEntityType["host"] = "host";
  LegacyEntityType["user"] = "user";
  return LegacyEntityType;
}({});
let EntityType = exports.EntityType = /*#__PURE__*/function (EntityType) {
  EntityType["user"] = "user";
  EntityType["host"] = "host";
  EntityType["service"] = "service";
  EntityType["generic"] = "generic";
  return EntityType;
}({});
let EntityIdentifierFields = exports.EntityIdentifierFields = /*#__PURE__*/function (EntityIdentifierFields) {
  EntityIdentifierFields["hostName"] = "host.name";
  EntityIdentifierFields["userName"] = "user.name";
  EntityIdentifierFields["serviceName"] = "service.name";
  EntityIdentifierFields["generic"] = "entity.id";
  return EntityIdentifierFields;
}({});
const EntityTypeToIdentifierField = exports.EntityTypeToIdentifierField = {
  [EntityType.host]: EntityIdentifierFields.hostName,
  [EntityType.user]: EntityIdentifierFields.userName,
  [EntityType.service]: EntityIdentifierFields.serviceName,
  [EntityType.generic]: EntityIdentifierFields.generic
};