"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexCase = exports.deleteIndexedCase = void 0;
var _common = require("@kbn/cases-plugin/common");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates a new case in security solution
 *
 * @param kbnClient
 * @param newCase
 */
const indexCase = async (kbnClient, newCase = {}) => {
  const newCaseReq = {
    title: `Malware Investigation (${Math.random().toString(32).substring(2, 6)})`,
    tags: [],
    severity: _common.CaseSeverity.LOW,
    description: 'foo',
    assignees: [],
    connector: {
      id: 'none',
      name: 'none',
      type: _common.ConnectorTypes.none,
      fields: null
    },
    settings: {
      syncAlerts: true,
      extractObservables: true
    },
    owner: 'securitySolution',
    ...newCase
  };
  const createdCase = (await kbnClient.request({
    method: 'POST',
    path: _common.CASES_URL,
    body: newCaseReq
  })).data;
  return {
    data: createdCase,
    cleanup: deleteIndexedCase.bind(undefined, kbnClient, createdCase)
  };
};
exports.indexCase = indexCase;
const deleteIndexedCase = async (kbnClient, data) => {
  try {
    await kbnClient.request({
      method: 'DELETE',
      path: _common.CASES_URL,
      query: {
        ids: JSON.stringify([data.id])
      }
    });
  } catch (_error) {
    var _response;
    const error = _error;

    // ignore 404 (not found) -data has already been deleted
    if (((_response = error.response) === null || _response === void 0 ? void 0 : _response.status) !== 404) {
      var _error$response$data, _error$response;
      const message = `${error.message}
  Request:
    ${error.request.method} ${error.request.path}
  Response Body:
    ${JSON.stringify((_error$response$data = (_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.data) !== null && _error$response$data !== void 0 ? _error$response$data : {}, null, 2)}`;
      throw new _errors.EndpointError(message, error);
    }
  }
  return {
    data: data.id
  };
};
exports.deleteIndexedCase = deleteIndexedCase;