"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserEntity = exports.ServiceEntity = exports.HostEntity = exports.GenericEntity = exports.EntityInternal = exports.EntityField = exports.Entity = exports.EngineMetadata = exports.Asset = void 0;
var _zod = require("@kbn/zod");
var _common = require("../../common/common.gen");
var _common2 = require("../../asset_criticality/common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Entities Schemas
 *   version: 1
 */

const EngineMetadata = exports.EngineMetadata = _zod.z.object({
  Type: _zod.z.string()
}).strict();
const EntityField = exports.EntityField = _zod.z.object({
  id: _zod.z.string(),
  name: _zod.z.string().optional(),
  type: _zod.z.string().optional(),
  sub_type: _zod.z.string().optional(),
  source: _zod.z.string().optional(),
  EngineMetadata: EngineMetadata.optional(),
  attributes: _zod.z.object({
    privileged: _zod.z.boolean().optional(),
    asset: _zod.z.boolean().optional(),
    managed: _zod.z.boolean().optional(),
    mfa_enabled: _zod.z.boolean().optional()
  }).strict().optional(),
  behaviors: _zod.z.object({
    brute_force_victim: _zod.z.boolean().optional(),
    new_country_login: _zod.z.boolean().optional(),
    used_usb_device: _zod.z.boolean().optional()
  }).strict().optional(),
  lifecycle: _zod.z.object({
    first_seen: _zod.z.string().datetime().optional(),
    last_activity: _zod.z.string().datetime().optional()
  }).strict().optional(),
  relationships: _zod.z.object({
    communicates_with: _zod.z.array(_zod.z.string()).optional(),
    depends_on: _zod.z.array(_zod.z.string()).optional(),
    dependent_of: _zod.z.array(_zod.z.string()).optional(),
    owns: _zod.z.array(_zod.z.string()).optional(),
    owned_by: _zod.z.array(_zod.z.string()).optional(),
    accesses_frequently: _zod.z.array(_zod.z.string()).optional(),
    accessed_frequently_by: _zod.z.array(_zod.z.string()).optional(),
    supervises: _zod.z.array(_zod.z.string()).optional(),
    supervised_by: _zod.z.array(_zod.z.string()).optional()
  }).strict().optional(),
  risk: _zod.z.object({
    /**
     * Lexical description of the entity's risk.
     */
    calculated_level: _common.EntityRiskLevels.optional(),
    /**
     * The raw numeric value of the given entity's risk score.
     */
    calculated_score: _zod.z.number().optional(),
    /**
     * The normalized numeric value of the given entity's risk score. Useful for comparing with other entities.
     */
    calculated_score_norm: _zod.z.number().min(0).max(100).optional()
  }).strict().optional()
}).strict();
const Asset = exports.Asset = _zod.z.object({
  id: _zod.z.string().optional(),
  name: _zod.z.string().optional(),
  owner: _zod.z.string().optional(),
  serial_number: _zod.z.string().optional(),
  model: _zod.z.string().optional(),
  vendor: _zod.z.string().optional(),
  environment: _zod.z.string().optional(),
  criticality: _common2.AssetCriticalityLevel.optional(),
  business_unit: _zod.z.string().optional()
}).strict();
const UserEntity = exports.UserEntity = _zod.z.object({
  '@timestamp': _zod.z.string().datetime().optional(),
  entity: EntityField,
  user: _zod.z.object({
    full_name: _zod.z.array(_zod.z.string()).optional(),
    domain: _zod.z.array(_zod.z.string()).optional(),
    roles: _zod.z.array(_zod.z.string()).optional(),
    name: _zod.z.string(),
    id: _zod.z.array(_zod.z.string()).optional(),
    email: _zod.z.array(_zod.z.string()).optional(),
    hash: _zod.z.array(_zod.z.string()).optional(),
    risk: _common.EntityRiskScoreRecord.optional()
  }).strict().optional(),
  asset: Asset.optional(),
  event: _zod.z.object({
    ingested: _zod.z.string().datetime().optional()
  }).strict().optional()
}).strict();
const HostEntity = exports.HostEntity = _zod.z.object({
  '@timestamp': _zod.z.string().datetime().optional(),
  entity: EntityField,
  host: _zod.z.object({
    hostname: _zod.z.array(_zod.z.string()).optional(),
    domain: _zod.z.array(_zod.z.string()).optional(),
    ip: _zod.z.array(_zod.z.string()).optional(),
    name: _zod.z.string(),
    id: _zod.z.array(_zod.z.string()).optional(),
    type: _zod.z.array(_zod.z.string()).optional(),
    mac: _zod.z.array(_zod.z.string()).optional(),
    architecture: _zod.z.array(_zod.z.string()).optional(),
    risk: _common.EntityRiskScoreRecord.optional(),
    entity: EntityField.optional()
  }).strict().optional(),
  asset: Asset.optional(),
  event: _zod.z.object({
    ingested: _zod.z.string().datetime().optional()
  }).strict().optional()
}).strict();
const ServiceEntity = exports.ServiceEntity = _zod.z.object({
  '@timestamp': _zod.z.string().datetime().optional(),
  entity: EntityField,
  service: _zod.z.object({
    name: _zod.z.string(),
    risk: _common.EntityRiskScoreRecord.optional(),
    entity: EntityField.optional()
  }).strict().optional(),
  asset: Asset.optional(),
  event: _zod.z.object({
    ingested: _zod.z.string().datetime().optional()
  }).strict().optional()
}).strict();
const GenericEntity = exports.GenericEntity = _zod.z.object({
  '@timestamp': _zod.z.string().datetime().optional(),
  entity: EntityField,
  asset: Asset.optional()
}).strict();
const EntityInternal = exports.EntityInternal = _zod.z.union([UserEntity, HostEntity, ServiceEntity, GenericEntity]);
const Entity = exports.Entity = EntityInternal;