"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PatchUpdateRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("./common");
var _schema_utils = require("../schema_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PatchUpdateRequestSchema = exports.PatchUpdateRequestSchema = {
  body: _configSchema.schema.object({
    name: _configSchema.schema.maybe(_common.ScriptNameSchema),
    platform: _configSchema.schema.maybe(_common.ScriptPlatformSchema),
    file: _configSchema.schema.maybe(_common.ScriptFileSchema),
    requiresInput: _configSchema.schema.maybe(_common.ScriptRequiresInputSchema),
    description: _configSchema.schema.maybe(_common.ScriptDescriptionSchema),
    instructions: _configSchema.schema.maybe(_common.ScriptInstructionsSchema),
    example: _configSchema.schema.maybe(_common.ScriptExampleSchema),
    pathToExecutable: _configSchema.schema.maybe(_common.ScriptPathToExecutableSchema),
    version: _configSchema.schema.maybe(_configSchema.schema.string({
      minLength: 1,
      validate: _schema_utils.validateNonEmptyString
    }))
  }, {
    validate: ({
      version,
      ...updates
    }) => {
      if (Object.keys(updates).length === 0) {
        return 'At least one field must be defined for update';
      }
    }
  }),
  params: _configSchema.schema.object({
    script_id: _configSchema.schema.string({
      validate: _schema_utils.validateNonEmptyString
    })
  })
};