"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListScriptsRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _scripts_library_utils = require("../../../endpoint/service/scripts_library/scripts_library_utils");
var _constants = require("../../../endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ListScriptsRequestSchema = exports.ListScriptsRequestSchema = {
  query: _configSchema.schema.maybe(_configSchema.schema.object({
    page: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: 1,
      min: 1
    })),
    pageSize: _configSchema.schema.maybe(_configSchema.schema.number({
      defaultValue: _constants.ENDPOINT_DEFAULT_PAGE_SIZE,
      min: 1,
      max: 1000
    })),
    sortField: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('name'), _configSchema.schema.literal('createdAt'), _configSchema.schema.literal('createdBy'), _configSchema.schema.literal('updatedAt'), _configSchema.schema.literal('updatedBy')])),
    sortDirection: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')], {
      defaultValue: 'asc'
    })),
    kuery: _configSchema.schema.maybe(_configSchema.schema.string({
      validate: value => (0, _scripts_library_utils.isScriptsLibraryKqlFilterValid)(value).error
    }))
  }))
};