"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateScriptRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateScriptRequestSchema = exports.CreateScriptRequestSchema = {
  body: _configSchema.schema.object({
    name: _common.ScriptNameSchema,
    platform: _common.ScriptPlatformSchema,
    file: _common.ScriptFileSchema,
    requiresInput: _configSchema.schema.maybe(_common.ScriptRequiresInputSchema),
    description: _configSchema.schema.maybe(_common.ScriptDescriptionSchema),
    instructions: _configSchema.schema.maybe(_common.ScriptInstructionsSchema),
    example: _configSchema.schema.maybe(_common.ScriptExampleSchema),
    pathToExecutable: _configSchema.schema.maybe(_common.ScriptPathToExecutableSchema)
  })
};